//------------------------------------------------------------------------------
// File: cmn_threads.cs
// This file contains the thread creation, destruction, and manipulation
// routines
// Author: Matthew Rudge
//------------------------------------------------------------------------------

////////////////////////////////////////////////////////////////////////////////
//! Creates a new thread object.  Thread remains in existence until it is 
//! destroyed
//! \param %sThread Name of thead object
//! \param %sEntry  Name of function that is called when thread starts
//! \param %sUpdate Name of function that receives thread update
//! \param %iSleep  Amount of time thread should sleep between updates - value
//! needs to be greater than zero and is in milliseconds
//! \param %bStart  True if the thread is to immediately start
//! \retval ThreadObject Id of thread object created   
////////////////////////////////////////////////////////////////////////////////
function slgCreateThread(%sThread, %sEntry, %sUpdate, %iSleep, %bStart)
{
   %thread = new ThreadObject(%sThread);
   %thread.setEntryMethod(%sEntry);
   %thread.setRunMethod(%sUpdate);
   %thread.setSleep(%iSleep);
   if(%bStart) {
      %thread.start();
   }
   return %thread;      
}

////////////////////////////////////////////////////////////////////////////////
//! Destroys a thread object
//! \param %idThread Thread object to destroy
////////////////////////////////////////////////////////////////////////////////
function slgDestroyThread(%idThread)
{
   %idThread.delete();
}

// End cmn_threads.cs